#ifndef AHLGREN_FRONT_END
#define AHLGREN_FRONT_END

#include <iostream>
#include <fstream>
#include <cctype>
#include <set>
#include "program.h"
#include "tokenizer.h"
#include "global.h"
#include "functor_tbl.h"

class Front_End {
public:
	Front_End() {}
	Front_End(const lp::Program& p) : kb(p) {}
	Front_End(lp::Program&& p) : kb(std::move(p)) {}
	// Clear program
	void clear() { kb.clear(); }
	// Print program to stream
	void print(ostream& os) const { os << kb; }
	// Go into interactive mode
	void interactive();
protected:
	int query(const lp::Functor& q, const std::set<lp::id_type>& qvars);
	lp::Program kb;
};

inline ostream& operator<<(ostream& os, const Front_End& fe) { fe.print(os); return os; }


#endif

